/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.errorhandling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.errorhandling.IFailedPartnerServiceResponseHandler;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import com.microsoft.store.partnercenter.models.ApiFault;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.io.IOException;
import java.text.MessageFormat;
import okhttp3.Response;

public class DefaultPartnerServiceErrorHandler
implements IFailedPartnerServiceResponseHandler {
    @Override
    public PartnerException handleFailedResponse(Response response) {
        return this.handleFailedResponse(response, null);
    }

    @Override
    public PartnerException handleFailedResponse(Response response, IRequestContext context) {
        String responsePayload;
        if (response == null) {
            throw new IllegalArgumentException("Response is null");
        }
        if (response.code() < 400) {
            throw new IllegalArgumentException("DefaultPartnerServiceErrorHandler: response is successful.");
        }
        try {
            if (response.body() == null || response.body().contentLength() == 0L) {
                throw new IllegalArgumentException("Response entity is null");
            }
            responsePayload = response.body().string();
        }
        catch (Exception e) {
            responsePayload = "";
        }
        ApiFault apiFault = null;
        PartnerException partnerException = null;
        PartnerLog.getInstance().logError(MessageFormat.format("Partner service failed response:{0}", responsePayload));
        ObjectMapper mapper = new ObjectMapper();
        try {
            apiFault = (ApiFault)mapper.readValue(responsePayload, ApiFault.class);
        }
        catch (IOException e) {
            PartnerLog.getInstance().logError("Could not parse error response: " + e.toString());
        }
        PartnerErrorCategory errorCategory = DefaultPartnerServiceErrorHandler.toPartnerErrorCategory(response.code());
        partnerException = apiFault != null ? new PartnerException(apiFault, context, errorCategory) : new PartnerException(StringHelper.isNullOrWhiteSpace(responsePayload) ? response.message() : responsePayload, context, errorCategory);
        return partnerException;
    }

    private static PartnerErrorCategory toPartnerErrorCategory(int statusCode) {
        PartnerErrorCategory errorCategory;
        switch (statusCode) {
            case 400: {
                errorCategory = PartnerErrorCategory.BAD_INPUT;
                break;
            }
            case 401: {
                errorCategory = PartnerErrorCategory.UNAUTHORIZED;
                break;
            }
            case 403: {
                errorCategory = PartnerErrorCategory.FORBIDDEN;
                break;
            }
            case 404: {
                errorCategory = PartnerErrorCategory.NOT_FOUND;
                break;
            }
            case 409: {
                errorCategory = PartnerErrorCategory.ALREADY_EXISTS;
                break;
            }
            case 503: {
                errorCategory = PartnerErrorCategory.SERVER_BUSY;
                break;
            }
            default: {
                errorCategory = PartnerErrorCategory.SERVER_ERROR;
            }
        }
        return errorCategory;
    }
}

