/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.exception;

import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.models.ApiFault;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import java.text.MessageFormat;

public class PartnerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private PartnerErrorCategory errorCategory;
    private ApiFault serviceErrorPayload;
    private IRequestContext context;

    public PartnerException() {
        this.setErrorCategory(PartnerErrorCategory.NOT_SPECIFIED);
    }

    public PartnerException(String message) {
        this(message, null);
    }

    public PartnerException(String message, Exception innerException) {
        super(message, innerException);
        this.setErrorCategory(PartnerErrorCategory.NOT_SPECIFIED);
    }

    public PartnerException(String message, IRequestContext context, PartnerErrorCategory errorCategory) {
        this(message, context, errorCategory, null);
    }

    public PartnerException(String message, IRequestContext context, PartnerErrorCategory errorCategory, Exception innerException) {
        super(message, innerException);
        this.setErrorCategory(errorCategory);
        this.setContext(context);
    }

    public PartnerException(ApiFault apiFault, IRequestContext context) {
        this(apiFault, context, PartnerErrorCategory.NOT_SPECIFIED, null);
    }

    public PartnerException(ApiFault apiFault, IRequestContext context, PartnerErrorCategory errorCategory) {
        this(apiFault, context, errorCategory, null);
    }

    public PartnerException(ApiFault apiFault, IRequestContext context, PartnerErrorCategory errorCategory, Exception innerException) {
        this(apiFault != null ? apiFault.getErrorMessage() : "", context, errorCategory, innerException);
        this.setServiceErrorPayload(apiFault);
    }

    public PartnerErrorCategory getErrorCategory() {
        return this.errorCategory;
    }

    public void setErrorCategory(PartnerErrorCategory value) {
        this.errorCategory = value;
    }

    public ApiFault getServiceErrorPayload() {
        return this.serviceErrorPayload;
    }

    public void setServiceErrorPayload(ApiFault value) {
        this.serviceErrorPayload = value;
    }

    public IRequestContext getContext() {
        return this.context;
    }

    public void setContext(IRequestContext value) {
        this.context = value;
    }

    @Override
    public String toString() {
        return MessageFormat.format("PartnerException: ErrorCategory: {0}, ServiceErrorPayload: {1}, Context: {2}, Base Description: {3}", new Object[]{this.getErrorCategory(), this.getServiceErrorPayload() != null ? this.getServiceErrorPayload().toString() : "null", this.getContext(), super.toString()});
    }
}

