/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.extensions;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.store.partnercenter.AuthenticationToken;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.extensions.BasePartnerCredentials;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.http.client.utils.URIBuilder;
import org.joda.time.DateTime;

public class ApplicationPartnerCredentials
extends BasePartnerCredentials {
    private final String applicationSecret;
    private final String aadApplicationDomain;
    private String activeDirectoryAuthority;
    private String graphApiEndpoint;

    public ApplicationPartnerCredentials(String aadApplicationId, String aadApplicationSecret, String aadApplicationDomain) {
        this(aadApplicationId, aadApplicationSecret, aadApplicationDomain, "https://login.microsoftonline.com/", "https://graph.windows.net");
    }

    public ApplicationPartnerCredentials(String aadApplicationId, String aadApplicationSecret, String aadApplicationDomain, String aadAuthorityEndpoint, String graphApiEndpoint) {
        super(aadApplicationId);
        if (StringHelper.isNullOrWhiteSpace(aadApplicationSecret)) {
            throw new IllegalArgumentException("aadApplicationSecret has to be set");
        }
        if (StringHelper.isNullOrWhiteSpace(aadApplicationDomain)) {
            throw new IllegalArgumentException("aadApplicationDomain has to be set");
        }
        if (StringHelper.isNullOrWhiteSpace(aadAuthorityEndpoint)) {
            throw new IllegalArgumentException("aadAuthorityEndpoint has to be set");
        }
        if (StringHelper.isNullOrWhiteSpace(graphApiEndpoint)) {
            throw new IllegalArgumentException("graphApiEndpoint has to be set");
        }
        this.applicationSecret = aadApplicationSecret;
        this.aadApplicationDomain = aadApplicationDomain;
        this.setActiveDirectoryAuthority(aadAuthorityEndpoint);
        this.setGraphApiEndpoint(graphApiEndpoint);
        PartnerService.getInstance().setRefreshCredentialsHandler(this);
    }

    public String getActiveDirectoryAuthority() {
        return this.activeDirectoryAuthority;
    }

    public void setActiveDirectoryAuthority(String value) {
        this.activeDirectoryAuthority = value;
    }

    public String getGraphApiEndpoint() {
        return this.graphApiEndpoint;
    }

    public void setGraphApiEndpoint(String value) {
        this.graphApiEndpoint = value;
    }

    @Override
    public void authenticate(IRequestContext requestContext) {
        IAuthenticationResult authResult = null;
        try {
            IClientCredential credential = ClientCredentialFactory.create((String)this.applicationSecret);
            ConfidentialClientApplication.Builder builder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.getClientId(), (IClientCredential)credential).authority(new URIBuilder(this.getActiveDirectoryAuthority()).setPath("/" + this.aadApplicationDomain).build().toString());
            if (requestContext != null) {
                builder = (ConfidentialClientApplication.Builder)builder.correlationId(requestContext.getCorrelationId().toString());
            }
            ConfidentialClientApplication app = builder.build();
            ClientCredentialParameters parameters = ClientCredentialParameters.builder(Collections.singleton(new URIBuilder(this.getGraphApiEndpoint()).setPath("/.default").build().toString())).build();
            CompletableFuture future = app.acquireToken(parameters);
            authResult = (IAuthenticationResult)future.get();
        }
        catch (Exception e) {
            throw new PartnerException("Failed to do the application AAD login", e);
        }
        this.setAADToken(new AuthenticationToken(authResult.accessToken(), new DateTime((Object)authResult.expiresOnDate())));
    }

    @Override
    public void onCredentialsRefreshNeeded(IPartnerCredentials credentials, IRequestContext context) {
        ApplicationPartnerCredentials partnerCredentials = (ApplicationPartnerCredentials)credentials;
        if (partnerCredentials != null) {
            partnerCredentials.authenticate(context);
        } else {
            PartnerLog.getInstance().logWarning(ApplicationPartnerCredentials.class + ": The given credentials are not supported.");
        }
    }
}

