/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.extensions;

import com.microsoft.store.partnercenter.AuthenticationToken;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.utils.StringHelper;
import org.joda.time.DateTime;

public abstract class BasePartnerCredentials
implements IPartnerCredentials {
    private AuthenticationToken token;
    private String clientId;

    public BasePartnerCredentials(String clientId) {
        if (StringHelper.isNullOrWhiteSpace(clientId)) {
            throw new IllegalArgumentException("clientId has to be set");
        }
        this.setClientId(clientId);
    }

    @Override
    public String getPartnerServiceToken() {
        return this.getAADToken().getToken();
    }

    @Override
    public DateTime getExpiresAt() {
        return this.getAADToken().getExpiryTime();
    }

    protected AuthenticationToken getAADToken() {
        return this.token;
    }

    protected void setAADToken(AuthenticationToken value) {
        this.token = value;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String value) {
        this.clientId = value;
    }

    @Override
    public boolean isExpired() {
        return this.getAADToken().isExpired();
    }

    public void authenticate() {
        this.authenticate(null);
    }

    public void authenticate(IRequestContext requestContext) {
    }
}

