/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.extensions;

import com.microsoft.store.partnercenter.AuthenticationToken;
import com.microsoft.store.partnercenter.IAadLoginHandler;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.extensions.ApplicationPartnerCredentials;
import com.microsoft.store.partnercenter.extensions.UserPartnerCredentials;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.utils.StringHelper;

public class PartnerCredentials {
    private static PartnerCredentials instance = new PartnerCredentials();

    private PartnerCredentials() {
    }

    public static PartnerCredentials getInstance() {
        return instance;
    }

    public IPartnerCredentials generateByApplicationCredentials(String clientId, String applicationSecret, String aadApplicationDomain) {
        return PartnerCredentials.getInstance().generateByApplicationCredentials(clientId, applicationSecret, aadApplicationDomain, null);
    }

    public IPartnerCredentials generateByApplicationCredentials(String clientId, String applicationSecret, String aadApplicationDomain, IRequestContext requestContext) {
        ApplicationPartnerCredentials partnerCredentials = new ApplicationPartnerCredentials(clientId, applicationSecret, aadApplicationDomain);
        partnerCredentials.authenticate(requestContext);
        return partnerCredentials;
    }

    public IPartnerCredentials generateByUserCredentials(String clientId, AuthenticationToken authenticationToken, IAadLoginHandler loginHandler) {
        UserPartnerCredentials partnerCredentials = new UserPartnerCredentials(clientId, authenticationToken, loginHandler);
        return partnerCredentials;
    }

    public IPartnerCredentials generateByApplicationCredentials(String clientId, String applicationSecret, String aadApplicationDomain, String aadAuthorityEndpoint, String graphEndpoint) {
        return PartnerCredentials.getInstance().generateByApplicationCredentials(clientId, applicationSecret, aadApplicationDomain, aadAuthorityEndpoint, graphEndpoint, null);
    }

    public IPartnerCredentials generateByApplicationCredentials(String clientId, String applicationSecret, String aadApplicationDomain, String aadAuthorityEndpoint, String graphEndpoint, IRequestContext requestContext) {
        if (StringHelper.isNullOrWhiteSpace(aadAuthorityEndpoint)) {
            throw new IllegalArgumentException("aadAuthorityEndpoint can't be empty");
        }
        if (StringHelper.isNullOrWhiteSpace(graphEndpoint)) {
            throw new IllegalArgumentException("graphEndpoint can't be empty");
        }
        ApplicationPartnerCredentials partnerCredentials = new ApplicationPartnerCredentials(clientId, applicationSecret, aadApplicationDomain, aadAuthorityEndpoint, graphEndpoint);
        partnerCredentials.authenticate(requestContext);
        return partnerCredentials;
    }
}

