/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.extensions;

import com.microsoft.store.partnercenter.AuthenticationToken;
import com.microsoft.store.partnercenter.IAadLoginHandler;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.extensions.BasePartnerCredentials;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;

public class UserPartnerCredentials
extends BasePartnerCredentials {
    private final IAadLoginHandler tokenRefresher;

    public UserPartnerCredentials(String clientId, AuthenticationToken aadAuthenticationToken) {
        this(clientId, aadAuthenticationToken, null);
    }

    public UserPartnerCredentials(String clientId, AuthenticationToken aadAuthenticationToken, IAadLoginHandler loginHandler) {
        super(clientId);
        if (aadAuthenticationToken == null) {
            throw new IllegalArgumentException("aadAuthenticationToken");
        }
        if (aadAuthenticationToken.isExpired()) {
            throw new IllegalArgumentException("aadAuthenticationToken is expired.");
        }
        this.setAADToken(aadAuthenticationToken);
        this.tokenRefresher = loginHandler;
        PartnerService.getInstance().setRefreshCredentialsHandler(this);
    }

    @Override
    public void onCredentialsRefreshNeeded(IPartnerCredentials credentials, IRequestContext context) {
        UserPartnerCredentials partnerCredentials = (UserPartnerCredentials)credentials;
        if (partnerCredentials != null) {
            partnerCredentials.refresh(context);
        } else {
            PartnerLog.getInstance().logWarning(UserPartnerCredentials.class + ": The given credentials are not supported.");
        }
    }

    private void refresh(IRequestContext context) {
        if (this.getAADToken().isExpired()) {
            if (this.tokenRefresher != null) {
                AuthenticationToken newAadToken = this.tokenRefresher.authenticate();
                if (newAadToken == null) {
                    String errorMessage = "Token refresher returned null token.";
                    PartnerLog.getInstance().logError(errorMessage);
                    throw new PartnerException(errorMessage, context, PartnerErrorCategory.UNAUTHORIZED);
                }
                if (newAadToken.isExpired()) {
                    String errorMessage = "Token refresher returned an expired token.";
                    PartnerLog.getInstance().logError(errorMessage);
                    throw new PartnerException(errorMessage, context, PartnerErrorCategory.UNAUTHORIZED);
                }
                this.setAADToken(newAadToken);
            } else {
                String errorMessage = "AAD Token needs refreshing but no handler was registered.";
                PartnerLog.getInstance().logWarning(errorMessage);
                throw new PartnerException(errorMessage, context, PartnerErrorCategory.UNAUTHORIZED);
            }
        }
        this.authenticate();
    }
}

