/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.extensions.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.extensions.products.IProductExtensionsByCountry;
import com.microsoft.store.partnercenter.models.products.InventoryCheckRequest;
import com.microsoft.store.partnercenter.models.products.InventoryItem;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class ProductExtensionsByCountryOperations
extends BasePartnerComponentString
implements IProductExtensionsByCountry {
    public ProductExtensionsByCountryOperations(IPartner rootPartnerOperations, String country) {
        super(rootPartnerOperations, country);
        if (StringHelper.isNullOrWhiteSpace(country)) {
            throw new IllegalArgumentException("country must be set");
        }
    }

    @Override
    public List<InventoryItem> checkInventory(InventoryCheckRequest checkRequest) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("CheckInventory").getParameters().get("Country"), (String)this.getContext()));
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<List<InventoryItem>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("CheckInventory").getPath(), parameters);
    }
}

