/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.invoices;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.invoices.EstimateCollectionOperations;
import com.microsoft.store.partnercenter.invoices.IEstimateCollection;
import com.microsoft.store.partnercenter.invoices.IInvoice;
import com.microsoft.store.partnercenter.invoices.IInvoiceCollection;
import com.microsoft.store.partnercenter.invoices.IInvoiceSummary;
import com.microsoft.store.partnercenter.invoices.IInvoiceSummaryCollection;
import com.microsoft.store.partnercenter.invoices.InvoiceOperations;
import com.microsoft.store.partnercenter.invoices.InvoiceSummaryCollectionOperations;
import com.microsoft.store.partnercenter.invoices.InvoiceSummaryOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.SeekBasedResourceCollection;
import com.microsoft.store.partnercenter.models.invoices.Invoice;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;

public class InvoiceCollection
extends BasePartnerComponentString
implements IInvoiceCollection {
    private static final int MaxPageSize = 200;
    private static final int MinPageSize = 1;

    public InvoiceCollection(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public IInvoice byId(String invoiceId) {
        if (StringHelper.isNullOrWhiteSpace(invoiceId)) {
            throw new IllegalArgumentException("invoiceId has to be set.");
        }
        return new InvoiceOperations(this.getPartner(), invoiceId);
    }

    @Override
    public IEstimateCollection getEstimates() {
        return new EstimateCollectionOperations(this.getPartner());
    }

    @Override
    public IInvoiceSummary getSummary() {
        return new InvoiceSummaryOperations(this.getPartner());
    }

    @Override
    public IInvoiceSummaryCollection getSummaries() {
        return new InvoiceSummaryCollectionOperations(this.getPartner());
    }

    @Override
    public SeekBasedResourceCollection<Invoice> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<Invoice>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getPath());
    }

    @Override
    public SeekBasedResourceCollection<Invoice> get(int offset, int size) {
        ParameterValidator.isIntInclusive(0, Integer.MAX_VALUE, offset, "The value of the page offset should be at least 0.");
        ParameterValidator.isIntInclusive(1, 200, size, MessageFormat.format("The page size must be an integer within the allowed range: {0}-{1}.", 1, 200));
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getParameters().get("Offset"), String.valueOf(offset)));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getParameters().get("Size"), String.valueOf(size)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<Invoice>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getPath(), parameters);
    }

    @Override
    public ResourceCollection<Invoice> query(IQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        if (query.getType() != QueryType.INDEXED && query.getType() != QueryType.SIMPLE) {
            throw new IllegalArgumentException("This type of query is not supported.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (query.getType() == QueryType.INDEXED) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getParameters().get("Size"), String.valueOf(query.getPageSize())));
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getParameters().get("Offset"), String.valueOf(query.getIndex())));
        }
        if (query.getFilter() != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)query.getFilter()), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
            }
            catch (JsonProcessingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<Invoice>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetInvoices").getPath(), parameters);
    }
}

