/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.invoices;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.invoices.IInvoiceLineItemCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.invoices.BillingProvider;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItem;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItemType;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class InvoiceLineItemCollectionOperations
extends BasePartnerComponentString
implements IInvoiceLineItemCollection {
    private BillingProvider billingProvider;
    private InvoiceLineItemType invoiceLineItemType;

    public InvoiceLineItemCollectionOperations(IPartner rootPartnerOperations, String invoiceId, BillingProvider billingProvider, InvoiceLineItemType invoiceLineItemType) {
        super(rootPartnerOperations, invoiceId);
        if (StringHelper.isNullOrEmpty(invoiceId)) {
            throw new IllegalArgumentException("invoiceId has to be set.");
        }
        if (billingProvider == BillingProvider.NONE) {
            throw new IllegalArgumentException("The billing provider is not valid.");
        }
        if (invoiceLineItemType == InvoiceLineItemType.NONE) {
            throw new IllegalArgumentException("The invoice line item type is not valid.");
        }
        this.billingProvider = billingProvider;
        this.invoiceLineItemType = invoiceLineItemType;
    }

    @Override
    public ResourceCollection<InvoiceLineItem> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<InvoiceLineItem>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoiceLineItems").getPath(), new Object[]{this.getContext(), this.billingProvider, this.invoiceLineItemType}));
    }

    @Override
    public ResourceCollection<InvoiceLineItem> get(int size, int offset) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoiceLineItems").getParameters().get("Size"), String.valueOf(size)));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoiceLineItems").getParameters().get("Offset"), String.valueOf(offset)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<InvoiceLineItem>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoiceLineItems").getPath(), new Object[]{this.getContext(), this.billingProvider, this.invoiceLineItemType}), parameters);
    }
}

