/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.invoices;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.invoices.IInvoice;
import com.microsoft.store.partnercenter.invoices.IInvoiceDocuments;
import com.microsoft.store.partnercenter.invoices.IInvoiceLineItemCollection;
import com.microsoft.store.partnercenter.invoices.IReceiptCollection;
import com.microsoft.store.partnercenter.invoices.IReconciliationLineItemCollection;
import com.microsoft.store.partnercenter.invoices.InvoiceDocumentsOperations;
import com.microsoft.store.partnercenter.invoices.InvoiceLineItemCollectionOperations;
import com.microsoft.store.partnercenter.invoices.ReceiptCollectionOperations;
import com.microsoft.store.partnercenter.invoices.ReconciliationLineItemCollectionOperations;
import com.microsoft.store.partnercenter.models.invoices.BillingPeriod;
import com.microsoft.store.partnercenter.models.invoices.BillingProvider;
import com.microsoft.store.partnercenter.models.invoices.Invoice;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItemType;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class InvoiceOperations
extends BasePartnerComponentString
implements IInvoice {
    public InvoiceOperations(IPartner rootPartnerOperations, String invoiceId) {
        super(rootPartnerOperations, invoiceId);
        if (StringHelper.isNullOrWhiteSpace(invoiceId)) {
            throw new IllegalArgumentException("invoiceId has to be set.");
        }
    }

    @Override
    public IInvoiceDocuments getDocuments() {
        return new InvoiceDocumentsOperations(this.getPartner(), (String)this.getContext());
    }

    @Override
    public IReceiptCollection getReceipts() {
        return new ReceiptCollectionOperations(this.getPartner(), (String)this.getContext());
    }

    @Override
    public IInvoiceLineItemCollection by(BillingProvider billingProvider, InvoiceLineItemType invoiceLineItemType) {
        return new InvoiceLineItemCollectionOperations(this.getPartner(), (String)this.getContext(), billingProvider, invoiceLineItemType);
    }

    @Override
    public IReconciliationLineItemCollection by(BillingProvider provider, InvoiceLineItemType invoiceLineItemType, String currencyCode, BillingPeriod period) {
        return new ReconciliationLineItemCollectionOperations(this.getPartner(), (String)this.getContext(), provider, invoiceLineItemType, currencyCode, period);
    }

    @Override
    public IReconciliationLineItemCollection by(BillingProvider provider, InvoiceLineItemType invoiceLineItemType, String currencyCode, BillingPeriod period, int pageSize) {
        return new ReconciliationLineItemCollectionOperations(this.getPartner(), (String)this.getContext(), provider, invoiceLineItemType, currencyCode, period, pageSize);
    }

    @Override
    public Invoice get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Invoice>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetInvoice").getPath(), this.getContext()));
    }
}

