/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.invoices;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.invoices.IReconciliationLineItemCollection;
import com.microsoft.store.partnercenter.models.SeekBasedResourceCollection;
import com.microsoft.store.partnercenter.models.invoices.BillingPeriod;
import com.microsoft.store.partnercenter.models.invoices.BillingProvider;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItem;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItemType;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ReconciliationLineItemCollectionOperations
extends BasePartnerComponent<String>
implements IReconciliationLineItemCollection {
    private final int maxPageSizeReconLineItems = 2000;
    private BillingProvider billingProvider;
    private String currencyCode;
    private InvoiceLineItemType invoiceLineItemType;
    private int pageSize;
    private BillingPeriod period;

    public ReconciliationLineItemCollectionOperations(IPartner rootPartnerOperations, String invoiceId, BillingProvider billingProvider, InvoiceLineItemType invoiceLineItemType, String currencyCode, BillingPeriod period) {
        super(rootPartnerOperations, invoiceId);
        if (StringHelper.isNullOrWhiteSpace(invoiceId)) {
            throw new IllegalArgumentException("invoiceId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(currencyCode)) {
            throw new IllegalArgumentException("currencyCode must be set");
        }
        this.billingProvider = billingProvider;
        this.invoiceLineItemType = invoiceLineItemType;
        this.currencyCode = currencyCode;
        this.period = period;
        this.pageSize = 2000;
    }

    public ReconciliationLineItemCollectionOperations(IPartner rootPartnerOperations, String invoiceId, BillingProvider billingProvider, InvoiceLineItemType invoiceLineItemType, String currencyCode, BillingPeriod period, int pageSize) {
        super(rootPartnerOperations, invoiceId);
        if (StringHelper.isNullOrWhiteSpace(invoiceId)) {
            throw new IllegalArgumentException("invoiceId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(currencyCode)) {
            throw new IllegalArgumentException("currencyCode must be set");
        }
        this.billingProvider = billingProvider;
        this.invoiceLineItemType = invoiceLineItemType;
        this.currencyCode = currencyCode;
        this.period = period;
        this.pageSize = pageSize;
    }

    @Override
    public SeekBasedResourceCollection<InvoiceLineItem> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getParameters().get("CurrencyCode"), this.currencyCode));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getParameters().get("InvoiceLineItemType"), this.invoiceLineItemType.toString()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getParameters().get("Period"), this.period.toString()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getParameters().get("Provider"), this.billingProvider.toString()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getParameters().get("Size"), String.valueOf(this.pageSize)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<InvoiceLineItem>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetReconciliationLineItems").getPath(), this.getContext()), parameters);
    }
}

