/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.logging;

import com.microsoft.store.partnercenter.logging.ILogger;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class PartnerLog
implements ILogger {
    private static PartnerLog logManagerSingleton = null;
    private final List<ILogger> registeredLoggers = new ArrayList<ILogger>();

    private PartnerLog() {
    }

    public static PartnerLog getInstance() {
        if (logManagerSingleton == null) {
            logManagerSingleton = new PartnerLog();
        }
        return logManagerSingleton;
    }

    public List<ILogger> getLoggers() {
        return this.registeredLoggers;
    }

    @Override
    public void logInformation(String message) {
        if (!StringHelper.isNullOrWhiteSpace(message)) {
            for (ILogger logger : this.registeredLoggers) {
                logger.logInformation(message);
            }
        }
    }

    @Override
    public void logWarning(String message) {
        if (!StringHelper.isNullOrWhiteSpace(message)) {
            for (ILogger logger : this.registeredLoggers) {
                logger.logWarning(message);
            }
        }
    }

    @Override
    public void logError(String message) {
        if (!StringHelper.isNullOrWhiteSpace(message)) {
            for (ILogger logger : this.registeredLoggers) {
                logger.logError(message);
            }
        }
    }
}

