/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.models;

import com.microsoft.store.partnercenter.models.ResourceBaseWithLinks;
import java.util.ArrayList;
import java.util.List;

public class ResourceCollectionWithLinks<TResource, TLinks>
extends ResourceBaseWithLinks<TLinks> {
    private List<TResource> items;
    private int totalCount;

    public ResourceCollectionWithLinks() {
        super("Collection");
        this.items = new ArrayList<TResource>();
    }

    public ResourceCollectionWithLinks(List<TResource> items) {
        super("Collection");
        this.items = items;
    }

    protected ResourceCollectionWithLinks(ResourceCollectionWithLinks<TResource, TLinks> resourceCollection) {
        super("Collection");
        if (resourceCollection == null) {
            throw new IllegalArgumentException("resourceCollection");
        }
        this.items = resourceCollection.items;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int value) {
        this.totalCount = value;
    }

    public Iterable<TResource> getItems() {
        return this.items;
    }

    public void setItems(List<TResource> value) {
        this.items = value;
    }

    public String toString() {
        StringBuilder collectionDescription = new StringBuilder();
        collectionDescription.append("Count: " + this.getTotalCount() + "\n");
        if (this.getItems() != null) {
            collectionDescription.append("Items:\n");
            for (TResource item : this.getItems()) {
                collectionDescription.append(item.toString() + "\n");
            }
        }
        return collectionDescription.toString();
    }
}

