/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.models.query;

import com.microsoft.store.partnercenter.models.query.CountQuery;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.IndexedQuery;
import com.microsoft.store.partnercenter.models.query.SeekOperation;
import com.microsoft.store.partnercenter.models.query.SeekQuery;
import com.microsoft.store.partnercenter.models.query.SimpleQuery;
import com.microsoft.store.partnercenter.models.query.filters.FieldFilter;
import com.microsoft.store.partnercenter.models.query.sort.Sort;

public class QueryFactory {
    private static QueryFactory __instance = new QueryFactory();

    private QueryFactory() {
    }

    public static QueryFactory getInstance() {
        return __instance;
    }

    public IQuery buildSimpleQuery(FieldFilter filter, Sort sortOption, Object token) {
        SimpleQuery query = new SimpleQuery();
        query.setFilter(filter);
        query.setSort(sortOption);
        query.setToken(token);
        return query;
    }

    public IQuery buildSimpleQuery(FieldFilter filter, Sort sortOption) {
        return this.buildSimpleQuery(filter, sortOption, null);
    }

    public IQuery buildSimpleQuery(FieldFilter filter) {
        return this.buildSimpleQuery(filter, null, null);
    }

    public IQuery buildSimpleQuery() {
        return this.buildSimpleQuery(null, null, null);
    }

    public IQuery buildIndexedQuery(int pageSize, int index, FieldFilter filter, Sort sortOption, Object token) {
        IndexedQuery query = new IndexedQuery();
        query.setPageSize(pageSize);
        query.setIndex(index);
        query.setFilter(filter);
        query.setSort(sortOption);
        query.setToken(token);
        return query;
    }

    public IQuery buildIndexedQuery(int pageSize, int index, FieldFilter filter, Sort sortOption) {
        return this.buildIndexedQuery(pageSize, index, filter, sortOption, null);
    }

    public IQuery buildIndexedQuery(int pageSize, int index, FieldFilter filter) {
        return this.buildIndexedQuery(pageSize, index, filter, null, null);
    }

    public IQuery buildIndexedQuery(int pageSize, int index) {
        return this.buildIndexedQuery(pageSize, index, null, null, null);
    }

    public IQuery buildIndexedQuery(int pageSize) {
        return this.buildIndexedQuery(pageSize, 0, null, null, null);
    }

    public IQuery buildCountQuery(FieldFilter filter, Object token) {
        CountQuery query = new CountQuery();
        query.setFilter(filter);
        query.setToken(token);
        return query;
    }

    public IQuery buildCountQuery(FieldFilter filter) {
        return this.buildCountQuery(filter, null);
    }

    public IQuery buildCountQuery() {
        return this.buildCountQuery(null, null);
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation, int pageSize, int index, FieldFilter filter, Sort sortingOption, Object token) {
        SeekQuery query = new SeekQuery();
        query.setSeekOperation(seekOperation);
        query.setPageSize(pageSize);
        query.setIndex(index);
        query.setFilter(filter);
        query.setSort(sortingOption);
        query.setToken(token);
        return query;
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation, int pageSize, int index, FieldFilter filter, Sort sortingOption) {
        return this.buildSeekQuery(seekOperation, pageSize, index, filter, sortingOption, null);
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation, int pageSize, int index, FieldFilter filter) {
        return this.buildSeekQuery(seekOperation, pageSize, index, filter, null, null);
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation, int pageSize, int index) {
        return this.buildSeekQuery(seekOperation, pageSize, index, null, null, null);
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation, int pageSize) {
        return this.buildSeekQuery(seekOperation, pageSize, 0, null, null, null);
    }

    public IQuery buildSeekQuery(SeekOperation seekOperation) {
        return this.buildSeekQuery(seekOperation, 0, 0, null, null, null);
    }
}

