/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.network;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceClient;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.retry.RetryStrategy;
import com.microsoft.rest.serializer.JacksonAdapter;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.errorhandling.DefaultPartnerServiceErrorHandler;
import com.microsoft.store.partnercenter.errorhandling.IFailedPartnerServiceResponseHandler;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.exception.PartnerResponseParseException;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import com.microsoft.store.partnercenter.models.Link;
import com.microsoft.store.partnercenter.models.entitlements.Artifact;
import com.microsoft.store.partnercenter.models.invoices.InvoiceLineItem;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.network.IPartnerServiceClient;
import com.microsoft.store.partnercenter.network.PartnerServiceRetryStrategy;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.requestcontext.RequestContextFactory;
import com.microsoft.store.partnercenter.utils.ArtifactDeserializer;
import com.microsoft.store.partnercenter.utils.InvoiceLineItemDeserializer;
import com.microsoft.store.partnercenter.utils.StringHelper;
import com.microsoft.store.partnercenter.utils.UriDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class PartnerServiceClient
extends ServiceClient
implements IPartnerServiceClient {
    static final String ACCEPT_HEADER = "Accept";
    static final String ACCEPT_HEADER_VALUE = "application/json";
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String AUTHORIZATION_SCHEME = "Bearer";
    static final String CLIENT_HEADER = "MS-PartnerCenter-Client";
    static final String CONTRACT_VERSION_HEADER = "MS-Contract-Version";
    static final String CORRELATION_ID_HEADER = "MS-CorrelationId";
    static final String LOCALE_HEADER = "X-Locale";
    static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static final String PARTNER_CENTER_APP_HEADER = "MS-PartnerCenter-Application";
    static final String REQUEST_ID_HEADER = "MS-RequestId";
    static final String SDK_VERSION_HEADER = "MS-SdkVersion";
    private IFailedPartnerServiceResponseHandler errorHandler = new DefaultPartnerServiceErrorHandler();
    private ObjectMapper jsonConverter;

    public PartnerServiceClient(String baseUrl) {
        super(new RestClient.Builder().withBaseUrl(baseUrl).withRetryStrategy((RetryStrategy)new PartnerServiceRetryStrategy(PartnerService.getInstance().getConfiguration().getDefaultMaxRetryAttempts())).withSerializerAdapter((SerializerAdapter)new JacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new ServiceResponseBuilder.Factory()).build());
    }

    public PartnerServiceClient(RestClient restClient) {
        super(restClient);
    }

    @Override
    public <T> T get(IPartner rootPartnerOperations, TypeReference<T> responseType, Link link) {
        Map<String, String> requestHeaders = this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE);
        if (link.getHeaders() != null) {
            for (KeyValuePair<String, String> header : link.getHeaders()) {
                requestHeaders.put(header.getKey(), header.getValue());
            }
        }
        Request request = new Request.Builder().headers(Headers.of(requestHeaders)).url(this.buildUrl(link.getUri().toString(), null, true)).get().build();
        return this.handleResponse(rootPartnerOperations, request, responseType);
    }

    @Override
    public <T> T get(IPartner rootPartnerOperations, TypeReference<T> responseType, String relativeUri) {
        return this.get(rootPartnerOperations, responseType, relativeUri, null);
    }

    @Override
    public <T> T get(IPartner rootPartnerOperations, TypeReference<T> responseType, String relativeUri, Map<String, String> headers, Collection<KeyValuePair<String, String>> parameters) {
        Map<String, String> requestHeaders = this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE);
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        Request request = new Request.Builder().headers(Headers.of(requestHeaders)).url(this.buildUrl(relativeUri, parameters, false)).get().build();
        return this.handleResponse(rootPartnerOperations, request, responseType);
    }

    @Override
    public InputStream getFileContents(IPartner rootPartnerOperations, String relativeUri, String acceptType) {
        try {
            Request request = new Request.Builder().headers(Headers.of(this.getRequestHeaders(rootPartnerOperations, acceptType))).url(this.buildUrl(relativeUri, null, false)).get().build();
            Response response = this.httpClient().newCall(request).execute();
            InputStream responseStream = response.body().byteStream();
            return responseStream;
        }
        catch (IOException ex) {
            PartnerLog.getInstance().logError(ex.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public <T> T get(IPartner rootPartnerOperations, TypeReference<T> responseType, String relativeUri, Collection<KeyValuePair<String, String>> parameters) {
        return this.get(rootPartnerOperations, responseType, relativeUri, null, parameters);
    }

    @Override
    public <T> T head(IPartner rootPartnerOperations, TypeReference<T> responseType, String relativeUri) {
        Headers headers = Headers.of(this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE));
        Request request = new Request.Builder().headers(headers).url(this.buildUrl(relativeUri, null, false)).head().build();
        return this.handleResponse(rootPartnerOperations, request, responseType);
    }

    @Override
    public <T, U> U patch(IPartner rootPartnerOperations, TypeReference<U> responseType, String relativeUri, T content) {
        Headers headers = Headers.of(this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE));
        try {
            Request request = new Request.Builder().headers(headers).url(this.buildUrl(relativeUri, null, false)).patch(RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.getJsonConverter().writeValueAsString(content))).build();
            return this.handleResponse(rootPartnerOperations, request, responseType);
        }
        catch (JsonProcessingException e) {
            throw new PartnerException("", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.REQUEST_PARSING);
        }
    }

    @Override
    public <T, U> U post(IPartner rootPartnerOperations, TypeReference<U> responseType, String relativeUri, T content) {
        return this.post(rootPartnerOperations, responseType, relativeUri, content, null);
    }

    @Override
    public <T, U> U post(IPartner rootPartnerOperations, TypeReference<U> responseType, String relativeUri, T content, Collection<KeyValuePair<String, String>> parameters) {
        Headers headers = Headers.of(this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE));
        try {
            Request request = new Request.Builder().headers(headers).url(this.buildUrl(relativeUri, parameters, false)).post(RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.getJsonConverter().writeValueAsString(content))).build();
            return this.handleResponse(rootPartnerOperations, request, responseType);
        }
        catch (JsonProcessingException e) {
            throw new PartnerException("", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.REQUEST_PARSING);
        }
    }

    @Override
    public <T, U> U put(IPartner rootPartnerOperations, TypeReference<U> responseType, String relativeUri, T content) {
        Headers headers = Headers.of(this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE));
        try {
            Request request = new Request.Builder().headers(headers).url(this.buildUrl(relativeUri, null, false)).put(RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.getJsonConverter().writeValueAsString(content))).build();
            return this.handleResponse(rootPartnerOperations, request, responseType);
        }
        catch (JsonProcessingException e) {
            throw new PartnerException("", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.REQUEST_PARSING);
        }
    }

    @Override
    public <T> void delete(IPartner rootPartnerOperations, TypeReference<T> responseType, String relativeUri) {
        Headers headers = Headers.of(this.getRequestHeaders(rootPartnerOperations, ACCEPT_HEADER_VALUE));
        Request request = new Request.Builder().headers(headers).url(this.buildUrl(relativeUri, null, false)).delete().build();
        this.handleResponse(rootPartnerOperations, request, responseType);
    }

    private ObjectMapper getJsonConverter() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new ObjectMapper();
            this.jsonConverter.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.jsonConverter.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.jsonConverter.registerModule((Module)new JodaModule());
            this.jsonConverter.registerModule((Module)new SimpleModule().addDeserializer(Artifact.class, (JsonDeserializer)new ArtifactDeserializer()));
            this.jsonConverter.registerModule((Module)new SimpleModule().addDeserializer(InvoiceLineItem.class, (JsonDeserializer)new InvoiceLineItemDeserializer()));
            this.jsonConverter.registerModule((Module)new SimpleModule().addDeserializer(URI.class, (JsonDeserializer)new UriDeserializer()));
            this.jsonConverter.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            this.jsonConverter.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return this.jsonConverter;
    }

    private String buildUrl(String relativeUri, Collection<KeyValuePair<String, String>> parameters, boolean isBuilt) {
        if (StringHelper.isNullOrEmpty(relativeUri)) {
            throw new IllegalArgumentException("resourcePath cannot be null");
        }
        StringBuilder address = new StringBuilder(PartnerService.getInstance().getApiRootUrl() + "/" + PartnerService.getInstance().getPartnerServiceApiVersion() + "/" + relativeUri);
        if (!isBuilt && parameters != null) {
            if (!parameters.isEmpty()) {
                address.append("?");
            }
            boolean firstParameter = true;
            for (KeyValuePair<String, String> queryParameter : parameters) {
                if (!firstParameter) {
                    address.append("&");
                }
                address.append(MessageFormat.format("{0}={1}", queryParameter.getKey(), queryParameter.getValue()));
                firstParameter = false;
            }
        }
        return address.toString();
    }

    private Map<String, String> getRequestHeaders(IPartner rootPartnerOperations, String acceptType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        IRequestContext requestContext = rootPartnerOperations.getRequestContext().getRequestId().equals(new UUID(0L, 0L)) ? RequestContextFactory.getInstance().create(rootPartnerOperations.getRequestContext().getCorrelationId(), UUID.randomUUID(), rootPartnerOperations.getRequestContext().getLocale()) : rootPartnerOperations.getRequestContext();
        if (rootPartnerOperations.getCredentials().isExpired()) {
            if (PartnerService.getInstance().getRefreshCredentialsHandler() != null) {
                try {
                    PartnerService.getInstance().getRefreshCredentialsHandler().onCredentialsRefreshNeeded(rootPartnerOperations.getCredentials(), rootPartnerOperations.getRequestContext());
                }
                catch (Exception refreshProblem) {
                    throw new PartnerException("Refreshing the credentials has failed.", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.UNAUTHORIZED, refreshProblem);
                }
                if (rootPartnerOperations.getCredentials().isExpired()) {
                    throw new PartnerException("The credential refresh mechanism provided expired credentials.", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.UNAUTHORIZED);
                }
            } else {
                throw new PartnerException("The partner credentials have expired. Please provide updated credentials.", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.UNAUTHORIZED);
            }
        }
        headers.put(AUTHORIZATION_HEADER, "Bearer " + rootPartnerOperations.getCredentials().getPartnerServiceToken());
        headers.put(CONTRACT_VERSION_HEADER, PartnerService.getInstance().getPartnerServiceApiVersion());
        headers.put(CORRELATION_ID_HEADER, requestContext.getCorrelationId().toString());
        headers.put(LOCALE_HEADER, requestContext.getLocale());
        headers.put(REQUEST_ID_HEADER, requestContext.getRequestId().toString());
        headers.put(SDK_VERSION_HEADER, PartnerService.getInstance().getSdkVersion());
        if (PartnerService.getInstance().getApplicationName() != null && !PartnerService.getInstance().getApplicationName().trim().isEmpty()) {
            headers.put(PARTNER_CENTER_APP_HEADER, PartnerService.getInstance().getApplicationName());
        }
        headers.put(CLIENT_HEADER, PartnerService.getInstance().getConfiguration().getPartnerCenterClient());
        headers.put(ACCEPT_HEADER, acceptType);
        return headers;
    }

    private <T> T handleResponse(IPartner rootPartnerOperations, Request request, TypeReference<T> responseType) {
        String responseBody = null;
        try {
            Response response = this.httpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                responseBody = response.body().string();
                Object value = StringHelper.isNullOrEmpty(responseBody) ? response : this.getJsonConverter().readValue(responseBody, responseType);
                response.close();
                return (T)value;
            }
            throw this.errorHandler.handleFailedResponse(response, rootPartnerOperations.getRequestContext());
        }
        catch (SocketTimeoutException ex) {
            throw new PartnerException("Socket timeout exception", rootPartnerOperations.getRequestContext(), PartnerErrorCategory.TIMEOUT, (Exception)ex);
        }
        catch (IOException ex) {
            throw new PartnerResponseParseException(responseBody, rootPartnerOperations.getRequestContext(), "Could not deserialize response. Detailed message: " + ex.getMessage(), (Exception)ex);
        }
    }
}

