/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.network;

import com.microsoft.rest.retry.RetryStrategy;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;

public class PartnerServiceRetryStrategy
extends RetryStrategy {
    private int maxRetryAttempts;
    static final String Name = "Partner Service Retry Strategy";
    static final List<Integer> nonRetryableHttpCodes = Arrays.asList(400, 401, 403, 404, 409, 417);

    public PartnerServiceRetryStrategy(int maxRetryAttempts) {
        super(Name, true);
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public boolean shouldRetry(int retryCount, Response response) {
        double exponentialBackOffTime = (Math.pow(2.0, retryCount) - 1.0) / 2.0;
        if (retryCount > this.maxRetryAttempts && nonRetryableHttpCodes.contains(response.code())) {
            return false;
        }
        if (response.isSuccessful()) {
            return false;
        }
        try {
            Thread.sleep((long)exponentialBackOffTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

