/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.offers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.offers.Offer;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.offers.ICustomerOfferCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerOfferCollectionOperations
extends BasePartnerComponentString
implements ICustomerOfferCollection {
    public CustomerOfferCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrEmpty(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
    }

    @Override
    public ResourceCollection<Offer> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerOffers").getPath(), this.getContext()));
    }

    @Override
    public ResourceCollection<Offer> get(int offset, int size) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerOffers").getParameters().get("Offset"), String.valueOf(offset)));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerOffers").getParameters().get("Size"), String.valueOf(size)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerOffers").getPath(), this.getContext()), parameters);
    }
}

