/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.offers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.offers.Offer;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.offers.IOfferAddOns;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import java.text.MessageFormat;
import java.util.ArrayList;

public class OfferAddOnsOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IOfferAddOns {
    public OfferAddOnsOperations(IPartner rootPartnerOperations, String offerId, String country) {
        super(rootPartnerOperations, new Tuple<String, String>(offerId, country));
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public ResourceCollection<Offer> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }

    @Override
    public ResourceCollection<Offer> get(int offset, int size) {
        ParameterValidator.isIntInclusive(0, Integer.MAX_VALUE, offset, "offset has to be non-negative.");
        ParameterValidator.isIntInclusive(1, Integer.MAX_VALUE, size, "size has to be positive.");
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getParameters().get("Offset"), String.valueOf(offset)));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getParameters().get("Size"), String.valueOf(size)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOfferAddons").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

