/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.offers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.offers.Offer;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.offers.CategoryOffersCollectionOperations;
import com.microsoft.store.partnercenter.offers.ICategoryOffersCollection;
import com.microsoft.store.partnercenter.offers.IOffer;
import com.microsoft.store.partnercenter.offers.IOfferCollection;
import com.microsoft.store.partnercenter.offers.OfferOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import java.util.ArrayList;

public class OfferCollectionOperations
extends BasePartnerComponentString
implements IOfferCollection {
    public OfferCollectionOperations(IPartner rootPartnerOperations, String country) {
        super(rootPartnerOperations, country);
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public IOffer byId(String offerId) {
        return new OfferOperations(this.getPartner(), offerId, (String)this.getContext());
    }

    @Override
    public ResourceCollection<Offer> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getParameters().get("Country"), (String)this.getContext()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getPath(), parameters);
    }

    @Override
    public ResourceCollection<Offer> get(int offset, int size) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getParameters().get("Country"), (String)this.getContext()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getParameters().get("Offset"), String.valueOf(offset)));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getParameters().get("Size"), String.valueOf(size)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Offer>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetOffers").getPath(), parameters);
    }

    @Override
    public ICategoryOffersCollection byCategory(String categoryId) {
        return new CategoryOffersCollectionOperations(this.getPartner(), categoryId, (String)this.getContext());
    }
}

