/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.offers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.offers.Offer;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.offers.IOffer;
import com.microsoft.store.partnercenter.offers.IOfferAddOns;
import com.microsoft.store.partnercenter.offers.OfferAddOnsOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class OfferOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IOffer {
    private IOfferAddOns addOns;

    public OfferOperations(IPartner rootPartnerOperations, String offerId, String country) {
        super(rootPartnerOperations, new Tuple<String, String>(offerId, country));
        if (StringHelper.isEmptyOrContainsWhiteSpace(offerId)) {
            throw new IllegalArgumentException("offerId has to be set.");
        }
        ParameterValidator.isValidCountryCode(country);
        this.addOns = new OfferAddOnsOperations(rootPartnerOperations, offerId, country);
    }

    @Override
    public IOfferAddOns getAddOns() {
        return this.addOns;
    }

    @Override
    public Offer get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOffer").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Offer>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOffer").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

