/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.orders;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.offers.BillingCycleType;
import com.microsoft.store.partnercenter.models.orders.Order;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.orders.IOrderCollectionByBillingCycleType;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class OrderCollectionByBillingCycleTypeOperations
extends BasePartnerComponent<Tuple<String, BillingCycleType>>
implements IOrderCollectionByBillingCycleType {
    public OrderCollectionByBillingCycleTypeOperations(IPartner rootPartnerOperations, String customerId, BillingCycleType billingCycleType) {
        super(rootPartnerOperations, new Tuple<String, BillingCycleType>(customerId, billingCycleType));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
    }

    @Override
    public ResourceCollection<Order> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOrdersByBillingCycleType").getParameters().get("BillingType"), ((BillingCycleType)((Object)((Tuple)this.getContext()).getItem2())).toString()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Order>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOrdersByBillingCycleType").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }

    @Override
    public ResourceCollection<Order> get(boolean includePrice) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOrdersByBillingCycleType").getParameters().get("BillingType"), ((BillingCycleType)((Object)((Tuple)this.getContext()).getItem2())).toString()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOrdersByBillingCycleType").getParameters().get("IncludePrice"), String.valueOf(includePrice)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Order>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOrdersByBillingCycleType").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

