/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.orders;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.offers.BillingCycleType;
import com.microsoft.store.partnercenter.models.orders.Order;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.orders.IOrder;
import com.microsoft.store.partnercenter.orders.IOrderCollection;
import com.microsoft.store.partnercenter.orders.IOrderCollectionByBillingCycleType;
import com.microsoft.store.partnercenter.orders.OrderCollectionByBillingCycleTypeOperations;
import com.microsoft.store.partnercenter.orders.OrderOperations;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class OrderCollectionOperations
extends BasePartnerComponentString
implements IOrderCollection {
    public OrderCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IOrderCollectionByBillingCycleType byBillingCycleType(BillingCycleType billingCycleType) {
        return new OrderCollectionByBillingCycleTypeOperations(this.getPartner(), (String)this.getContext(), billingCycleType);
    }

    @Override
    public IOrder byId(String orderId) {
        return new OrderOperations(this.getPartner(), (String)this.getContext(), orderId);
    }

    @Override
    public Order create(Order newOrder) {
        if (newOrder == null) {
            throw new IllegalArgumentException("The newOrder parameter cannot be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Order>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOrders").getPath(), this.getContext()), newOrder);
    }

    @Override
    public ResourceCollection<Order> get() {
        return this.get(false);
    }

    @Override
    public ResourceCollection<Order> get(Boolean includePrice) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOrders").getParameters().get("IncludePrice"), String.valueOf(includePrice)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Order>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOrders").getPath(), this.getContext()), parameters);
    }
}

