/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.orders;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.orders.OrderLineItemActivationLink;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.orders.IOrderLineItemActivationLink;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class OrderLineItemActivationLinkOperations
extends BasePartnerComponent<TripletTuple<String, String, Integer>>
implements IOrderLineItemActivationLink {
    public OrderLineItemActivationLinkOperations(IPartner rootPartnerOperations, String customerId, String orderId, int lineItemNumber) {
        super(rootPartnerOperations, new TripletTuple<String, String, Integer>(customerId, orderId, lineItemNumber));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(orderId)) {
            throw new IllegalArgumentException("orderId must be set");
        }
    }

    @Override
    public ResourceCollection<OrderLineItemActivationLink> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<OrderLineItemActivationLink>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetActivationLinksByLineItemNumber").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2(), ((TripletTuple)this.getContext()).getItem3()));
    }
}

