/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.orders;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.orders.Order;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.orders.IOrder;
import com.microsoft.store.partnercenter.orders.IOrderLineItemCollection;
import com.microsoft.store.partnercenter.orders.IOrderProvisioningStatus;
import com.microsoft.store.partnercenter.orders.OrderLineItemCollectionOperations;
import com.microsoft.store.partnercenter.orders.OrderProvisioningStatusOperations;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class OrderOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IOrder {
    public OrderOperations(IPartner rootPartnerOperations, String customerId, String orderId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, orderId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
        if (StringHelper.isNullOrWhiteSpace(orderId)) {
            throw new IllegalArgumentException("orderId must be set.");
        }
    }

    @Override
    public Order get() {
        return this.get(false);
    }

    @Override
    public Order get(Boolean includePrice) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetOrder").getParameters().get("IncludePrice"), String.valueOf(includePrice)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Order>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetOrder").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), parameters);
    }

    @Override
    public IOrderLineItemCollection getOrderLineItems() {
        return new OrderLineItemCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
    }

    @Override
    public IOrderProvisioningStatus getProvisioningStatus() {
        return new OrderProvisioningStatusOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
    }

    @Override
    public Order patch(Order order) {
        if (order == null) {
            throw new IllegalArgumentException("Order can't be null");
        }
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<Order>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateOrder").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), order);
    }
}

