/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.QuintupleTuple;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegmentByReservationScopeOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AvailabilityCollectionByTargetSegmentByReservationScopeOperations
extends BasePartnerComponent<QuintupleTuple<String, String, String, String, String>>
implements IAvailabilityCollectionByTargetSegmentByReservationScopeOperations {
    public AvailabilityCollectionByTargetSegmentByReservationScopeOperations(IPartner rootPartnerOperations, String productId, String skuId, String country, String targetSegment, String reservationScope) {
        super(rootPartnerOperations, new QuintupleTuple<String, String, String, String, String>(productId, skuId, country, targetSegment, reservationScope));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(reservationScope)) {
            throw new IllegalArgumentException("reservationScope must be set");
        }
    }

    @Override
    public ResourceCollection<Availability> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("Country"), (String)((QuintupleTuple)this.getContext()).getItem3()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("TargetSegment"), (String)((QuintupleTuple)this.getContext()).getItem4()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("ReservationScope"), (String)((QuintupleTuple)this.getContext()).getItem5()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Availability>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getPath(), ((QuintupleTuple)this.getContext()).getItem1(), ((QuintupleTuple)this.getContext()).getItem2()), parameters);
    }
}

