/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.QuadrupleTuple;
import com.microsoft.store.partnercenter.products.AvailabilityCollectionByTargetSegmentByReservationScopeOperations;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegment;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegmentByReservationScopeOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AvailabilityCollectionByTargetSegmentOperations
extends BasePartnerComponent<QuadrupleTuple<String, String, String, String>>
implements IAvailabilityCollectionByTargetSegment {
    public AvailabilityCollectionByTargetSegmentOperations(IPartner rootPartnerOperations, String productId, String skuId, String country, String targetSegment) {
        super(rootPartnerOperations, new QuadrupleTuple<String, String, String, String>(productId, skuId, country, targetSegment));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
    }

    @Override
    public IAvailabilityCollectionByTargetSegmentByReservationScopeOperations byReservationScope(String reservationScope) {
        return new AvailabilityCollectionByTargetSegmentByReservationScopeOperations(this.getPartner(), (String)((QuadrupleTuple)this.getContext()).getItem1(), (String)((QuadrupleTuple)this.getContext()).getItem2(), (String)((QuadrupleTuple)this.getContext()).getItem3(), (String)((QuadrupleTuple)this.getContext()).getItem4(), reservationScope);
    }

    @Override
    public ResourceCollection<Availability> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("Country"), (String)((QuadrupleTuple)this.getContext()).getItem3()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("TargetSegment"), (String)((QuadrupleTuple)this.getContext()).getItem4()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Availability>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getPath(), ((QuadrupleTuple)this.getContext()).getItem1(), ((QuadrupleTuple)this.getContext()).getItem2()), parameters);
    }
}

