/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.AvailabilityCollectionByTargetSegmentOperations;
import com.microsoft.store.partnercenter.products.AvailabilityOperations;
import com.microsoft.store.partnercenter.products.IAvailability;
import com.microsoft.store.partnercenter.products.IAvailabilityCollection;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegment;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AvailabilityCollectionOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements IAvailabilityCollection {
    public AvailabilityCollectionOperations(IPartner rootPartnerOperations, String productId, String skuId, String country) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(productId, skuId, country));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public IAvailability byId(String availabilityId) {
        return new AvailabilityOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), availabilityId, (String)((TripletTuple)this.getContext()).getItem3());
    }

    @Override
    public IAvailabilityCollectionByTargetSegment byTargetSegment(String targetSegment) {
        return new AvailabilityCollectionByTargetSegmentOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), (String)((TripletTuple)this.getContext()).getItem3(), targetSegment);
    }

    @Override
    public ResourceCollection<Availability> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getParameters().get("Country"), (String)((TripletTuple)this.getContext()).getItem3()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Availability>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailabilities").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2()), parameters);
    }
}

