/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.QuadrupleTuple;
import com.microsoft.store.partnercenter.products.IAvailability;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AvailabilityOperations
extends BasePartnerComponent<QuadrupleTuple<String, String, String, String>>
implements IAvailability {
    public AvailabilityOperations(IPartner rootPartnerOperations, String productId, String skuId, String availabilityId, String country) {
        super(rootPartnerOperations, new QuadrupleTuple<String, String, String, String>(productId, skuId, availabilityId, country));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(availabilityId)) {
            throw new IllegalArgumentException("availabilityId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public Availability get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailability").getParameters().get("Country"), (String)((QuadrupleTuple)this.getContext()).getItem4()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Availability>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAvailability").getPath(), ((QuadrupleTuple)this.getContext()).getItem1(), ((QuadrupleTuple)this.getContext()).getItem2(), ((QuadrupleTuple)this.getContext()).getItem3()), parameters);
    }
}

