/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Product;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.IProductCollectionByCountryByTargetViewByTargetSegment;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;

public class ProductCollectionByCountryByTargetViewByTargetSegmentOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements IProductCollectionByCountryByTargetViewByTargetSegment {
    public ProductCollectionByCountryByTargetViewByTargetSegmentOperations(IPartner rootPartnerOperations, String targetView, String country, String targetSegment) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(targetView, country, targetSegment));
        if (StringHelper.isNullOrWhiteSpace(targetView)) {
            throw new IllegalArgumentException("targetView must be set");
        }
        ParameterValidator.isValidCountryCode(country);
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
    }

    @Override
    public ResourceCollection<Product> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getParameters().get("TargetView"), (String)((TripletTuple)this.getContext()).getItem1()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getParameters().get("Country"), (String)((TripletTuple)this.getContext()).getItem2()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getParameters().get("TargetSegment"), (String)((TripletTuple)this.getContext()).getItem3()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Product>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getPath(), parameters);
    }
}

