/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Product;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.products.IProductCollectionByCountryByTargetView;
import com.microsoft.store.partnercenter.products.IProductCollectionByCountryByTargetViewByTargetSegment;
import com.microsoft.store.partnercenter.products.ProductCollectionByCountryByTargetViewByTargetSegmentOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;

public class ProductCollectionByCountryByTargetViewOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IProductCollectionByCountryByTargetView {
    public ProductCollectionByCountryByTargetViewOperations(IPartner rootPartnerOperations, String targetView, String country) {
        super(rootPartnerOperations, new Tuple<String, String>(targetView, country));
        if (StringHelper.isNullOrWhiteSpace(targetView)) {
            throw new IllegalArgumentException("targetView must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public IProductCollectionByCountryByTargetViewByTargetSegment byTargetSegment(String targetSegment) {
        return new ProductCollectionByCountryByTargetViewByTargetSegmentOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), targetSegment);
    }

    @Override
    public ResourceCollection<Product> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getParameters().get("TargetView"), (String)((Tuple)this.getContext()).getItem1()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Product>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetProducts").getPath(), parameters);
    }
}

