/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.products.Product;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.products.IProduct;
import com.microsoft.store.partnercenter.products.ISkuCollection;
import com.microsoft.store.partnercenter.products.SkuCollectionOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ProductOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IProduct {
    private ISkuCollection skus;

    public ProductOperations(IPartner rootPartnerOperations, String productId, String country) {
        super(rootPartnerOperations, new Tuple<String, String>(productId, country));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public ISkuCollection getSkus() {
        if (this.skus == null) {
            this.skus = new SkuCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.skus;
    }

    @Override
    public Product get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetProduct").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Product>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetProduct").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

