/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.ISkuCollectionByTargetSegment;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class SkuCollectionByTargetSegmentOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements ISkuCollectionByTargetSegment {
    public SkuCollectionByTargetSegmentOperations(IPartner rootPartnerOperations, String productId, String country, String targetSegment) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(productId, country, targetSegment));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
    }

    @Override
    public ResourceCollection<Sku> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetSkus").getParameters().get("Country"), (String)((TripletTuple)this.getContext()).getItem2()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetSkus").getParameters().get("TargetSegment"), (String)((TripletTuple)this.getContext()).getItem3()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Sku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSkus").getPath(), ((TripletTuple)this.getContext()).getItem1()), parameters);
    }
}

