/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.products.ISku;
import com.microsoft.store.partnercenter.products.ISkuCollection;
import com.microsoft.store.partnercenter.products.ISkuCollectionByTargetSegment;
import com.microsoft.store.partnercenter.products.SkuCollectionByTargetSegmentOperations;
import com.microsoft.store.partnercenter.products.SkuOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class SkuCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISkuCollection {
    public SkuCollectionOperations(IPartner rootPartnerOperations, String productId, String country) {
        super(rootPartnerOperations, new Tuple<String, String>(productId, country));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public ISku byId(String skuId) {
        return new SkuOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), skuId, (String)((Tuple)this.getContext()).getItem2());
    }

    @Override
    public ISkuCollectionByTargetSegment byTargetSegment(String targetSegment) {
        return new SkuCollectionByTargetSegmentOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), targetSegment);
    }

    @Override
    public ResourceCollection<Sku> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetSkus").getParameters().get("Country"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Sku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSkus").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

