/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.AvailabilityCollectionOperations;
import com.microsoft.store.partnercenter.products.IAvailabilityCollection;
import com.microsoft.store.partnercenter.products.ISku;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class SkuOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements ISku {
    private IAvailabilityCollection availabilities;

    public SkuOperations(IPartner rootPartnerOperations, String productId, String skuId, String country) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(productId, skuId, country));
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        ParameterValidator.isValidCountryCode(country);
    }

    @Override
    public IAvailabilityCollection getAvailabilities() {
        if (this.availabilities == null) {
            this.availabilities = new AvailabilityCollectionOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), (String)((TripletTuple)this.getContext()).getItem3());
        }
        return this.availabilities;
    }

    @Override
    public Sku get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetSku").getParameters().get("Country"), (String)((TripletTuple)this.getContext()).getItem3()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Sku>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSku").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2()), parameters);
    }
}

