/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.productupgrades;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.productupgrades.ProductUpgradeEligibility;
import com.microsoft.store.partnercenter.models.productupgrades.ProductUpgradeRequest;
import com.microsoft.store.partnercenter.productupgrades.IProductUpgrade;
import com.microsoft.store.partnercenter.productupgrades.IProductUpgradeCollection;
import com.microsoft.store.partnercenter.productupgrades.ProductUpgradeOperations;
import java.text.MessageFormat;
import okhttp3.Response;

public class ProductUpgradeCollectionOperations
extends BasePartnerComponentString
implements IProductUpgradeCollection {
    public ProductUpgradeCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public IProductUpgrade byId(String id) {
        return new ProductUpgradeOperations(this.getPartner(), id);
    }

    @Override
    public ProductUpgradeEligibility checkEligibility(ProductUpgradeRequest productUpgradeRequest) {
        if (productUpgradeRequest == null) {
            throw new IllegalArgumentException("The productUpgradeRequest parameter cannot be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<ProductUpgradeEligibility>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetProductUpgradeEligibility").getPath(), this.getContext()), productUpgradeRequest);
    }

    @Override
    public String create(ProductUpgradeRequest newEntity) {
        if (newEntity == null) {
            throw new IllegalArgumentException("The newEntity parameter cannot be null.");
        }
        Response response = this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Response>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpgradeProduct").getPath(), this.getContext()), newEntity);
        return response.header("location");
    }
}

