/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.qualification;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.customers.CustomerQualification;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.validationcodes.ValidationCode;
import com.microsoft.store.partnercenter.qualification.ICustomerQualification;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerQualificationOperations
extends BasePartnerComponentString
implements ICustomerQualification {
    public CustomerQualificationOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrEmpty(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
    }

    @Override
    public CustomerQualification get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<CustomerQualification>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerQualification").getPath(), this.getContext()));
    }

    @Override
    public CustomerQualification update(CustomerQualification customerQualification) {
        if (customerQualification == null) {
            throw new IllegalArgumentException("customerQualification must be set");
        }
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<CustomerQualification>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCustomerQualification").getPath(), this.getContext()), customerQualification);
    }

    @Override
    public CustomerQualification update(CustomerQualification customerQualification, ValidationCode governmentCommunityCloudValidationCode) {
        if (customerQualification == null) {
            throw new IllegalArgumentException("customerQualification must be set");
        }
        if (governmentCommunityCloudValidationCode == null) {
            throw new IllegalArgumentException("governmentCommunityCloudValidationCode must be set");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCustomerQualification").getParameters().get("GovernmentCommunityCloudValidationCode"), governmentCommunityCloudValidationCode.getValidationId()));
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<CustomerQualification>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCustomerQualification").getPath(), this.getContext()), customerQualification);
    }
}

