/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.ratecards;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ratecards.AzureRateCard;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.ratecards.IAzureRateCard;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;

public class AzureRateCardOperations
extends BasePartnerComponentString
implements IAzureRateCard {
    public AzureRateCardOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public AzureRateCard get(String currency, String region) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (!StringHelper.isEmptyOrContainsWhiteSpace(currency)) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureRateCard").getParameters().get("Currency"), currency));
        }
        if (!StringHelper.isEmptyOrContainsWhiteSpace(region)) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureRateCard").getParameters().get("Region"), region));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<AzureRateCard>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetAzureRateCard").getPath(), parameters);
    }

    @Override
    public AzureRateCard getShared(String currency, String region) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (!StringHelper.isEmptyOrContainsWhiteSpace(currency)) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureSharedRateCard").getParameters().get("Currency"), currency));
        }
        if (!StringHelper.isEmptyOrContainsWhiteSpace(region)) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureSharedRateCard").getParameters().get("Region"), region));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<AzureRateCard>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetAzureSharedRateCard").getPath(), parameters);
    }
}

