/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.relationships;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.relationships.PartnerRelationship;
import com.microsoft.store.partnercenter.models.relationships.PartnerRelationshipType;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.relationships.IRelationshipCollection;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class RelationshipCollectionOperations
extends BasePartnerComponentString
implements IRelationshipCollection {
    public RelationshipCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public ResourceCollection<PartnerRelationship> get(PartnerRelationshipType partnerRelationshipType) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetPartnerRelationships").getParameters().get("RelationshipType"), partnerRelationshipType.toString()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<PartnerRelationship>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetPartnerRelationships").getPath(), parameters);
    }

    @Override
    public ResourceCollection<PartnerRelationship> Query(PartnerRelationshipType partnerRelationshipType, IQuery query) {
        if (query.getType() != QueryType.SIMPLE) {
            throw new IllegalArgumentException("This type of query is not supported.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (query.getFilter() != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetPartnerRelationships").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)query.getFilter()), "UTF-8")));
            }
            catch (JsonProcessingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
            }
            catch (UnsupportedEncodingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<PartnerRelationship>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetPartnerRelationships").getPath(), parameters);
    }
}

