/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.requestcontext;

import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.UUID;

public class RequestContext
implements IRequestContext {
    private UUID __RequestId;
    private UUID __CorrelationId;
    private String __Locale;

    public RequestContext() {
        this(UUID.randomUUID(), new UUID(0L, 0L), null);
    }

    public RequestContext(String locale) {
        this(UUID.randomUUID(), new UUID(0L, 0L), locale);
    }

    public RequestContext(UUID correlationId) {
        this(correlationId, new UUID(0L, 0L), null);
    }

    public RequestContext(UUID correlationId, String locale) {
        this(correlationId, new UUID(0L, 0L), locale);
    }

    public RequestContext(UUID correlationId, UUID requestId, String locale) {
        if (StringHelper.isNullOrWhiteSpace(locale)) {
            locale = PartnerService.getInstance().getConfiguration().getDefaultLocale();
        }
        this.setCorrelationId(correlationId);
        this.setRequestId(requestId);
        this.setLocale(locale);
    }

    @Override
    public UUID getRequestId() {
        return this.__RequestId;
    }

    public void setRequestId(UUID value) {
        this.__RequestId = value;
    }

    @Override
    public UUID getCorrelationId() {
        return this.__CorrelationId;
    }

    public void setCorrelationId(UUID value) {
        this.__CorrelationId = value;
    }

    @Override
    public String getLocale() {
        return this.__Locale;
    }

    public void setLocale(String value) {
        this.__Locale = value;
    }

    public String toString() {
        return MessageFormat.format("Request Id: {0}, Correlation Id: {1}, Locale: {2}" + this.getRequestId().toString(), this.getCorrelationId().toString(), this.getLocale());
    }
}

