/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.serviceincidents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.serviceincidents.ServiceIncidents;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.serviceincidents.IServiceIncidentCollection;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ServiceIncidentCollectionOperations
extends BasePartnerComponentString
implements IServiceIncidentCollection {
    public ServiceIncidentCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public ResourceCollection<ServiceIncidents> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<ServiceIncidents>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetServiceIncidents").getPath(), this.getContext()));
    }

    @Override
    public ResourceCollection<ServiceIncidents> get(IQuery serviceIncidentsQuery) {
        if (serviceIncidentsQuery == null) {
            throw new IllegalArgumentException("serviceIncidentsQuery can't be null");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (serviceIncidentsQuery.getFilter() != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("SearchPartnerServiceRequests").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)serviceIncidentsQuery.getFilter()), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
            }
            catch (JsonProcessingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<ServiceIncidents>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetServiceIncidents").getPath(), parameters);
    }
}

