/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.servicerequests;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.servicerequests.ServiceRequest;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.servicerequests.IServiceRequest;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerServiceRequestOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IServiceRequest {
    public CustomerServiceRequestOperations(IPartner rootPartnerOperations, String customerId, String serviceRequestId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, serviceRequestId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId can't be null");
        }
        if (StringHelper.isNullOrWhiteSpace(serviceRequestId)) {
            throw new IllegalArgumentException("serviceRequestId can't be null");
        }
    }

    @Override
    public ServiceRequest get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ServiceRequest>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetServiceRequestCustomer").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public ServiceRequest patch(ServiceRequest updatePayload) {
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<ServiceRequest>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateServiceRequestCustomer").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), updatePayload);
    }
}

