/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.servicerequests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.servicerequests.ServiceRequest;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.servicerequests.IPartnerServiceRequestCollection;
import com.microsoft.store.partnercenter.servicerequests.IServiceRequest;
import com.microsoft.store.partnercenter.servicerequests.ISupportTopicsCollection;
import com.microsoft.store.partnercenter.servicerequests.PartnerServiceRequestOperations;
import com.microsoft.store.partnercenter.servicerequests.SupportTopicsCollectionOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;

public class PartnerServiceRequestCollectionOperations
extends BasePartnerComponentString
implements IPartnerServiceRequestCollection {
    private static final int MIN_PAGE_SIZE = 1;
    private static final int MAX_PAGE_SIZE = 1000;

    public PartnerServiceRequestCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public ISupportTopicsCollection getSupportTopics() {
        return new SupportTopicsCollectionOperations(this.getPartner());
    }

    @Override
    public IServiceRequest byId(String serviceRequestId) {
        return new PartnerServiceRequestOperations(this.getPartner(), serviceRequestId);
    }

    @Override
    public ResourceCollection<ServiceRequest> query(IQuery serviceRequestsQuery) {
        if (serviceRequestsQuery == null) {
            throw new IllegalArgumentException("serviceRequestsQuery can't be null");
        }
        if (serviceRequestsQuery.getType() != QueryType.INDEXED && serviceRequestsQuery.getType() != QueryType.SIMPLE) {
            throw new IllegalArgumentException("Specified query type is not supported.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (serviceRequestsQuery.getType() == QueryType.INDEXED) {
            ParameterValidator.isIntInclusive(1, 1000, serviceRequestsQuery.getPageSize(), MessageFormat.format("Allowed page size values are from {0}-{1}", 1, 1000));
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("SearchPartnerServiceRequests").getParameters().get("Size"), String.valueOf(serviceRequestsQuery.getPageSize())));
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("SearchPartnerServiceRequests").getParameters().get("Offset"), String.valueOf(serviceRequestsQuery.getIndex())));
        }
        if (serviceRequestsQuery.getFilter() != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("SearchPartnerServiceRequests").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)serviceRequestsQuery.getFilter()), "UTF-8")));
            }
            catch (JsonProcessingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
            }
            catch (UnsupportedEncodingException e) {
                throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<ServiceRequest>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("SearchPartnerServiceRequests").getPath(), parameters);
    }

    @Override
    public ResourceCollection<ServiceRequest> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<ServiceRequest>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetAllServiceRequestsPartner").getPath());
    }

    @Override
    public ServiceRequest create(ServiceRequest serviceRequest, String agentLocale) {
        if (serviceRequest == null) {
            throw new IllegalArgumentException("serviceRequest can't be null");
        }
        if (agentLocale == null) {
            throw new IllegalArgumentException("agentLocale can't be null");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<ServiceRequest>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateServiceRequest").getPath(), agentLocale), serviceRequest);
    }
}

