/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscribedskus;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.licenses.LicenseGroupId;
import com.microsoft.store.partnercenter.models.licenses.SubscribedSku;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.subscribedskus.ICustomerSubscribedSkuCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class CustomerSubscribedSkuCollectionOperations
extends BasePartnerComponent<String>
implements ICustomerSubscribedSkuCollection {
    public CustomerSubscribedSkuCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public ResourceCollection<SubscribedSku> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<SubscribedSku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscribedSkus").getPath(), this.getContext()));
    }

    @Override
    public ResourceCollection<SubscribedSku> get(List<LicenseGroupId> licenseGroupIds) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        for (LicenseGroupId groupId : licenseGroupIds) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscribedSkus").getParameters().get("licenseGroupIds"), groupId.toString()));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<SubscribedSku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscribedSkus").getPath(), this.getContext()), parameters);
    }
}

