/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.genericoperations.IEntireEntityCollectionRetrievalOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.subscriptions.Subscription;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class PartnerSubscriptionCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IEntireEntityCollectionRetrievalOperations<Subscription, ResourceCollection<Subscription>> {
    public PartnerSubscriptionCollectionOperations(IPartner rootPartnerOperations, String customerId, String partnerId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, partnerId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
        if (StringHelper.isNullOrWhiteSpace(partnerId)) {
            throw new IllegalArgumentException("partnerId must be set.");
        }
    }

    @Override
    public ResourceCollection<Subscription> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscriptionsByPartner").getParameters().get("PartnerId"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Subscription>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscriptionsByPartner").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

