/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.genericoperations.IEntireEntityCollectionRetrievalOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.subscriptions.Subscription;
import com.microsoft.store.partnercenter.subscriptions.ISubscription;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionCollection;
import com.microsoft.store.partnercenter.subscriptions.OrderSubscriptionCollectionOperations;
import com.microsoft.store.partnercenter.subscriptions.PartnerSubscriptionCollectionOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionOperations;
import com.microsoft.store.partnercenter.usage.ISubscriptionMonthlyUsageRecordCollection;
import com.microsoft.store.partnercenter.usage.SubscriptionMonthlyUsageRecordCollectionOperations;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class SubscriptionCollectionOperations
extends BasePartnerComponentString
implements ISubscriptionCollection {
    private ISubscriptionMonthlyUsageRecordCollection usageRecords;

    public SubscriptionCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        this.usageRecords = new SubscriptionMonthlyUsageRecordCollectionOperations(this.getPartner(), (String)this.getContext());
    }

    @Override
    public ISubscriptionMonthlyUsageRecordCollection getUsageRecords() {
        return this.usageRecords;
    }

    @Override
    public IEntireEntityCollectionRetrievalOperations<Subscription, ResourceCollection<Subscription>> byOrder(String orderId) {
        ParameterValidator.isValidUriQueryValue(orderId, "orderId is an invalid query value");
        return new OrderSubscriptionCollectionOperations(this.getPartner(), (String)this.getContext(), orderId);
    }

    @Override
    public IEntireEntityCollectionRetrievalOperations<Subscription, ResourceCollection<Subscription>> byPartner(String partnerId) {
        ParameterValidator.isValidUriQueryValue(partnerId, "partnerId is an invalid query value");
        return new PartnerSubscriptionCollectionOperations(this.getPartner(), (String)this.getContext(), partnerId);
    }

    @Override
    public ISubscription byId(String subscriptionId) {
        return new SubscriptionOperations(this.getPartner(), (String)this.getContext(), subscriptionId);
    }

    @Override
    public ResourceCollection<Subscription> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Subscription>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSubscriptions").getPath(), this.getContext()));
    }
}

