/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.subscriptions.Conversion;
import com.microsoft.store.partnercenter.models.subscriptions.ConversionResult;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionConversionCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class SubscriptionConversionCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISubscriptionConversionCollection {
    public SubscriptionConversionCollectionOperations(IPartner rootPartnerOperations, String customerId, String subscriptionId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, subscriptionId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(subscriptionId)) {
            throw new IllegalArgumentException("subscriptionId must be set");
        }
    }

    @Override
    public ConversionResult create(Conversion conversion) {
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<ConversionResult>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSubscriptionConversions").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), conversion);
    }

    @Override
    public ResourceCollection<Conversion> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Conversion>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSubscriptionConversions").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }
}

