/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.subscriptions.AzureEntitlement;
import com.microsoft.store.partnercenter.models.subscriptions.Subscription;
import com.microsoft.store.partnercenter.models.subscriptions.SubscriptionActivationResult;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.subscriptions.ISubscription;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionActivationLinks;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionAddOnCollection;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionConversionCollection;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionProvisioningStatus;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionRegistration;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionRegistrationStatus;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionSupportContact;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionUpgradeCollection;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionActivationLinksOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionAddOnCollectionOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionConversionCollectionOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionProvisioningStatusOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionRegistrationOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionRegistrationStatusOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionSupportContactOperations;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionUpgradeCollectionOperations;
import com.microsoft.store.partnercenter.usage.ISubscriptionUsageRecordCollection;
import com.microsoft.store.partnercenter.usage.ISubscriptionUsageSummary;
import com.microsoft.store.partnercenter.usage.SubscriptionUsageRecordCollectionOperations;
import com.microsoft.store.partnercenter.usage.SubscriptionUsageSummaryOperations;
import com.microsoft.store.partnercenter.utilization.IUtilizationCollection;
import com.microsoft.store.partnercenter.utilization.UtilizationCollectionOperations;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class SubscriptionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISubscription {
    private ISubscriptionActivationLinks subscriptionActivationLinks;
    private ISubscriptionAddOnCollection subscriptionAddOnsOperations;
    private ISubscriptionUpgradeCollection subscriptionUpgradeOperations;
    private ISubscriptionUsageRecordCollection usageRecordsOperations;
    private ISubscriptionUsageSummary subscriptionUsageSummaryOperations;
    private IUtilizationCollection subscriptionUtilizationOperations;
    private ISubscriptionProvisioningStatus subscriptionProvisioningStatusOperations;
    private ISubscriptionSupportContact subscriptionSupportContactOperations;
    private ISubscriptionRegistration subscriptionRegistrationOperations;
    private ISubscriptionRegistrationStatus subscriptionRegistrationStatusOperations;
    private ISubscriptionConversionCollection subscriptionConversionOperations;

    public SubscriptionOperations(IPartner rootPartnerOperations, String customerId, String subscriptionId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, subscriptionId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
        if (StringHelper.isNullOrWhiteSpace(subscriptionId)) {
            throw new IllegalArgumentException("subscriptionId must be set.");
        }
    }

    @Override
    public SubscriptionActivationResult activate() {
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<SubscriptionActivationResult>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("Activate3ppSubscription").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), null);
    }

    @Override
    public ISubscriptionActivationLinks getActivationLinks() {
        if (this.subscriptionActivationLinks == null) {
            this.subscriptionActivationLinks = new SubscriptionActivationLinksOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionActivationLinks;
    }

    @Override
    public ISubscriptionAddOnCollection getAddOns() {
        if (this.subscriptionAddOnsOperations == null) {
            this.subscriptionAddOnsOperations = new SubscriptionAddOnCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionAddOnsOperations;
    }

    @Override
    public ResourceCollection<AzureEntitlement> getAzurePlanSubscriptionEntitlements() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<AzureEntitlement>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureEntitlements").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public ISubscriptionUpgradeCollection getUpgrades() {
        if (this.subscriptionUpgradeOperations == null) {
            this.subscriptionUpgradeOperations = new SubscriptionUpgradeCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionUpgradeOperations;
    }

    @Override
    public ISubscriptionUsageRecordCollection getUsageRecords() {
        if (this.usageRecordsOperations == null) {
            this.usageRecordsOperations = new SubscriptionUsageRecordCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.usageRecordsOperations;
    }

    @Override
    public ISubscriptionUsageSummary getUsageSummary() {
        if (this.subscriptionUsageSummaryOperations == null) {
            this.subscriptionUsageSummaryOperations = new SubscriptionUsageSummaryOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionUsageSummaryOperations;
    }

    @Override
    public IUtilizationCollection getUtilization() {
        if (this.subscriptionUtilizationOperations == null) {
            this.subscriptionUtilizationOperations = new UtilizationCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionUtilizationOperations;
    }

    @Override
    public ISubscriptionProvisioningStatus getProvisioningStatus() {
        if (this.subscriptionProvisioningStatusOperations == null) {
            this.subscriptionProvisioningStatusOperations = new SubscriptionProvisioningStatusOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionProvisioningStatusOperations;
    }

    @Override
    public ISubscriptionSupportContact getSupportContact() {
        if (this.subscriptionSupportContactOperations == null) {
            this.subscriptionSupportContactOperations = new SubscriptionSupportContactOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionSupportContactOperations;
    }

    @Override
    public ISubscriptionRegistration getRegistration() {
        if (this.subscriptionRegistrationOperations == null) {
            this.subscriptionRegistrationOperations = new SubscriptionRegistrationOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionRegistrationOperations;
    }

    @Override
    public ISubscriptionRegistrationStatus getRegistrationStatus() {
        if (this.subscriptionRegistrationStatusOperations == null) {
            this.subscriptionRegistrationStatusOperations = new SubscriptionRegistrationStatusOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionRegistrationStatusOperations;
    }

    @Override
    public ISubscriptionConversionCollection getConversions() {
        if (this.subscriptionConversionOperations == null) {
            this.subscriptionConversionOperations = new SubscriptionConversionCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.subscriptionConversionOperations;
    }

    @Override
    public Subscription get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Subscription>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSubscription").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public Subscription patch(Subscription subscription) {
        if (subscription == null) {
            throw new IllegalArgumentException("subscription is required.");
        }
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<Subscription>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateSubscription").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), subscription);
    }
}

