/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.subscriptions.SupportContact;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionSupportContact;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class SubscriptionSupportContactOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISubscriptionSupportContact {
    public SubscriptionSupportContactOperations(IPartner rootPartnerOperations, String customerId, String subscriptionId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, subscriptionId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
        if (StringHelper.isNullOrWhiteSpace(subscriptionId)) {
            throw new IllegalArgumentException("subscriptionId must be set.");
        }
    }

    @Override
    public SupportContact get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SupportContact>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSubscriptionSupportContact").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public SupportContact update(SupportContact supportContact) {
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<SupportContact>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateSubscriptionSupportContact").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), supportContact);
    }
}

