/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.subscriptions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.subscriptions.Upgrade;
import com.microsoft.store.partnercenter.models.subscriptions.UpgradeResult;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionUpgradeCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class SubscriptionUpgradeCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISubscriptionUpgradeCollection {
    public SubscriptionUpgradeCollectionOperations(IPartner rootPartnerOperations, String customerId, String subscriptionId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, subscriptionId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId should be set.");
        }
        if (StringHelper.isNullOrWhiteSpace(subscriptionId)) {
            throw new IllegalArgumentException("subscriptionId should be set.");
        }
    }

    @Override
    public ResourceCollection<Upgrade> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Upgrade>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetSubscriptionUpgrades").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public UpgradeResult create(Upgrade subscriptionUpgrade) {
        if (subscriptionUpgrade == null) {
            throw new IllegalArgumentException("The subscriptionUpgrade is a required parameter.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<UpgradeResult>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("PostSubscriptionUpgrade").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), subscriptionUpgrade);
    }
}

