/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.usage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.usage.SpendingBudget;
import com.microsoft.store.partnercenter.usage.ICustomerUsageSpendingBudget;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerUsageSpendingBudgetOperations
extends BasePartnerComponentString
implements ICustomerUsageSpendingBudget {
    public CustomerUsageSpendingBudgetOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
    }

    @Override
    public SpendingBudget get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SpendingBudget>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsageSpendingBudget").getPath(), this.getContext()));
    }

    @Override
    public SpendingBudget patch(SpendingBudget usageSpendingBudget) {
        if (usageSpendingBudget == null) {
            throw new IllegalArgumentException("usage spending budget is required.");
        }
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<SpendingBudget>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("PatchCustomerUsageSpendingBudget").getPath(), this.getContext()), usageSpendingBudget);
    }
}

